#####
#  cnc router diagnostics
#  wites Gcode file to draw a set of geometric patterns
#  for either pen plotting or cutting
#  written by f.pirz 8/15/2010
#
#  arguments:
#	filename
#	patsize - size of pattern in inches (float)
#	nx, ny - number of patterns to be written in x and y dimensions (integer)

import sys
# code constants
fd = 10 # feed rate for draw/cut
fp = 5	# feed rate for plunge
zc = .1 # z clearance
zd = -.1 # z draw/cut 

#####
#  proceedure to draw a square 
def cncsquare (x0,y0,x1,y1):
	cncout.write( "G00 X"+str(x0)+" Y"+str(y0)+"\n" )	# move to origin
	cncout.write( "G01 F"+str(fp)+" Z"+str(zd)+"\n" )	# pen down
	cncout.write( "G01 F"+str(fd)+" X"+str(x1)+"\n" )
	cncout.write( "G01 Y"+str(y1)+"\n" )
	cncout.write( "G01 X"+str(x0)+"\n" )
	cncout.write( "G01 Y"+str(y0)+"\n" )
	cncout.write( "G00 Z"+str(zc)+"\n" )
	return 0

#####
#  proceedure to draw the diagonals of a square 
def cncdiag (x0,y0,x1,y1):
	cncout.write( "G00 X"+str(x0)+" Y"+str(y0)+"\n" )	# move to origin
	cncout.write( "G01 F"+str(fp)+" Z"+str(zd)+"\n" )	# pen down
	cncout.write( "G01 F"+str(fd)+" X"+str(x1)+" Y"+str(y1)+"\n" )
	cncout.write( "G00 Z"+str(zc)+"\n" )			# pen up
	cncout.write( "G01 F"+str(fd)+" X"+str(x0)+" Y"+str(y1)+"\n" )
	cncout.write( "G01 F"+str(fp)+" Z"+str(zd)+"\n" )	# pen down
	cncout.write( "G01 F"+str(fd)+" X"+str(x1)+" Y"+str(y0)+"\n" )
	cncout.write( "G00 Z"+str(zc)+"\n" )
	return 0

#####
#  proceedure to draw a circle bounded by the square 
def cnccirc (x0,y0,x1,y1):
	xc = (x0+x1)/2	# calc center
	yc = (y0+y1)/2
	d = xc - x0	# calc radius
	cncout.write( "G00 X"+str(xc)+" Y"+str(y0)+"\n" )	# move to start
	cncout.write( "G01 F"+str(fp)+" Z"+str(zd)+"\n" )	# pen down
	cncout.write( "G03 F"+str(fd)+" X"+str(x1)+" Y"+str(yc)+" J"+str(d)+"\n" ) #arc1
	cncout.write( "G03 X"+str(xc)+" Y"+str(y1)+" I"+str(-d)+"\n" ) #arc2
	cncout.write( "G03 X"+str(x0)+" Y"+str(yc)+" J"+str(-d)+"\n" ) #arc3
	cncout.write( "G03 X"+str(xc)+" Y"+str(y0)+" I"+str(d)+"\n" ) #arc4
	cncout.write( "G00 Z"+str(zc)+"\n" )
	return 0
#####
#  program code starts here

if len(sys.argv) < 5:
	print "missing args: expected <file><psize><#x><#y>"
	quit (0)
cncfile = sys.argv[1]
psize = float(sys.argv[2])
numx = int(sys.argv[3])
numy = int(sys.argv[4])

print "args ", cncfile, psize, numx, numy

cncout = open(cncfile, 'w')
# write preamble, list parameters
cncout.write ("(cnc diagnostic code - f. pirz)\n" )
cncout.write ("(draws squares, with diagonals and circles)\n" )
cncout.write ("(arguments: Filename " +cncfile+ " Pattern size " +str(psize)+ ")\n" )
cncout.write ("(Number of Patterns: x " +str(numx)+" y " +str(numy)+ ")\n" )
cncout.write ("(Feed rate cut " +str(fd)+ " Feed rate plunge " +str(fp)+ ")\n" )
cncout.write ("(Drawing Plane " +str(zd)+ " Clearance plane " +str(zc)+ ")\n" )
# write Gcode headers
cncout.write ("G20"\n" )
cncout.write ("G90"\n" )
cncout.write ("G00 Z"+str(zc)+"\n" )

cncout.write ("(Squares)\n" )
for jy in range (0,numy):
	for jx in range (0,numx):
		px0 = jx * psize
		py0 = jy * psize
		px1 = px0 + psize
		py1 = py0 + psize
		cncsquare (px0,py0,px1,py1)

cncout.write ("(Diagonals)\n" )
for jy in range (0,numy):
	for jx in range (0,numx):
		px0 = jx * psize
		py0 = jy * psize
		px1 = px0 + psize
		py1 = py0 + psize	
		cncdiag (px0,py0,px1,py1)

cncout.write ("(Circles)\n" )
for jy in range (0,numy):
	for jx in range (0,numx):
		px0 = jx * psize
		py0 = jy * psize
		px1 = px0 + psize
		py1 = py0 + psize	
		cnccirc (px0,py0,px1,py1)

