#####
#  cnc router diagnostics
#  wites Gcode file to draw a set of geometric patterns
#  for either pen plotting or cutting
#  written by f.pirz 8/15/2010
#
#  arguments:
#	filename
#	patsize - size of pattern in inches (float)
#	nx, ny - number of patterns to be written in x and y dimensions (integer)

import sys
# code constants
fd = 30 # feed rate for draw/cut
fp = 15	# feed rate for plunge
zc = .25 # z clearance
zd = -.175 # z draw/cut 

#####
#  proceedure to draw a square 
def cncsquare (x0,y0,x1,y1):
	cncout.write( "G00 X"+str(x0)+" Y"+str(y0)+"\n" )	# move to origin
	cncout.write( "G01 F"+str(fp)+" Z"+str(zd)+"\n" )	# pen down
	cncout.write( "G01 F"+str(fd)+" X"+str(x1)+"\n" )
	cncout.write( "G01 Y"+str(y1)+"\n" )
	cncout.write( "G01 X"+str(x0)+"\n" )
	cncout.write( "G01 Y"+str(y0)+"\n" )
	cncout.write( "G00 Z"+str(zc)+"\n" )
	return 0

#####
#  proceedure to draw the diagonals of a square 
def cncdiag (x0,y0,x1,y1):
	cncout.write( "G00 X"+str(x0)+" Y"+str(y0)+"\n" )	# move to origin
	cncout.write( "G01 F"+str(fp)+" Z"+str(zd)+"\n" )	# pen down
	cncout.write( "G01 F"+str(fd)+" X"+str(x1)+" Y"+str(y1)+"\n" )
	cncout.write( "G00 Z"+str(zc)+"\n" )			# pen up
	cncout.write( "G00 F"+str(fd)+" X"+str(x0)+" Y"+str(y1)+"\n" )
	cncout.write( "G01 F"+str(fp)+" Z"+str(zd)+"\n" )	# pen down
	cncout.write( "G01 F"+str(fd)+" X"+str(x1)+" Y"+str(y0)+"\n" )
	cncout.write( "G00 Z"+str(zc)+"\n" )
	return 0

#####
#  proceedure to draw a circle bounded by the square 
def cnccirc (x0,y0,x1,y1):
	xc = (x0+x1)/2	# calc center
	yc = (y0+y1)/2
	d = xc - x0	# calc radius
	cncout.write( "G00 X"+str(xc)+" Y"+str(y0)+"\n" )	# move to start
	cncout.write( "G01 F"+str(fp)+" Z"+str(zd)+"\n" )	# pen down
	cncout.write( "G03 F"+str(fd)+" X"+str(x1)+" Y"+str(yc)+" J"+str(d)+"\n" ) #arc1
	cncout.write( "G03 X"+str(xc)+" Y"+str(y1)+" I"+str(-d)+"\n" ) #arc2
	cncout.write( "G03 X"+str(x0)+" Y"+str(yc)+" J"+str(-d)+"\n" ) #arc3
	cncout.write( "G03 X"+str(xc)+" Y"+str(y0)+" I"+str(d)+"\n" ) #arc4
	cncout.write( "G00 Z"+str(zc)+"\n" )
	return 0

#####
#  proceedure to drill a hole 
def cncdrill (x0,y0):
	cncout.write( "(hole "+str(x0)+" "+str(y0)+")\n" )
	cncout.write( "G00 X"+str(x0)+" Y"+str(y0)+"\n" )	# move to hole location
	cncout.write( "G01 F"+str(fp)+" Z"+str(zd)+"\n" )	# drill cycle down
	cncout.write( "G00 Z"+str(zc)+"\n" )	# drill cycle up
	return 0

#####
#  proceedure to cnc write preamble
def cnc_preamble (cncfile, message):
# write preamble, list parameters
	cncout.write ("(" +message+ ")\n" )
	cncout.write ("(arguments: Filename " +cncfile+ " Pattern size " +str(psize)+ ")\n" )
	cncout.write ("(Number of Patterns: x " +str(numx)+" y " +str(numy)+ ")\n" )
	cncout.write ("(Feed rate cut " +str(fd)+ " Feed rate plunge " +str(fp)+ ")\n" )
	cncout.write ("(Drawing Plane " +str(zd)+ " Clearance plane " +str(zc)+ ")\n" )
# write Gcode headers
	cncout.write ("(preamble)\n" )
	cncout.write ("G20\n" )	# inches
	cncout.write ("G90\n" )	# absolute dist
	cncout.write ("G00 Z"+str(zc)+"\n" )	# move to clearance plane
	cncout.write ("(T1: Size)\n" )	# tool size message
	cncout.write ("M06 T1\n" )	# tool change
	cncout.write ("M03\n" )	# start spindle
	return 0

#####
# write postamble
def cnc_postamble ():
	cncout.write ("(wrapup)\n" )
	cncout.write ("G00 X0 Y0\n" )
	cncout.write ("M05\n" )	# stop spindle
	cncout.write ("M30\n" )	# stop program
	return 0

#####
#  program code starts here

psize = 16
numx = 2
numy = 2

# first file, drill holes
cncfile= "test_cut1.fgc"
print "args ", cncfile, psize, numx, numy

cncout = open(cncfile, 'w')
cnc_preamble ( cncfile, "test_cut - circle center" )
cncout.write ("(Center Holes)\n" )
cncdrill (4.5,4.5)
cncdrill (12.5,4.5)
cncdrill (4.5,12.5)
cncdrill (12.5,12.5)
cncout.write ("(Square Holes)\n" )
cncdrill (1.5,1.5)
cncdrill (7.5,7.5)
cncdrill (9.5,1.5)
cncdrill (15.5,7.5)
cncdrill (1.5,9.5)
cncdrill (7.5,15.5)
cncdrill (9.5,9.5)
cncdrill (15.5,15.5)
cnc_postamble ()
cncout.close ()

# second file, cut circles
cncfile= "test_cut2.fgc"
print "args ", cncfile, psize, numx, numy

cncout = open(cncfile, 'w')
cnc_preamble ( cncfile, "test_cut - circle" )

cncout.write ("(Circles)\n" )
cnccirc (1.5,1.5,7.5,7.5)
cnccirc (9.5,1.5,15.5,7.5)
cnccirc (1.5,9.5,7.5,15.5)
cnccirc (9.5,9.5,15.5,15.5)
cnc_postamble ()
cncout.close ()

# third file, cut squares
cncfile= "test_cut3.fgc"
print "args ", cncfile, psize, numx, numy

cncout = open(cncfile, 'w')
cnc_preamble ( cncfile, "test_cut - square" )

cncout.write ("(Squares)\n" )
cncsquare (1,1,8,8)
cncsquare (9,1,16,8)
cncsquare (1,9,8,16)
cncsquare (9,9,16,16)

cnc_postamble ()
cncout.close ()




